Imports System.ComponentModel
Imports System.Drawing
Imports System.WinForms


Public Class Form1
    Inherits System.WinForms.Form
    
    Dim sc As New MySubClass()
    
    Public Sub New()
        MyBase.New()
        Form1 = Me
        InitializeComponent()
        
        sc.SetRefToTextBox(Me)
    End Sub
    
    'Form overrides dispose to clean up the component list.
    Public Overrides Sub Dispose()
        MyBase.Dispose()
        components.Dispose()
    End Sub
    
#Region " Windows Form Designer generated code "
    
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    
    Private WithEvents TextBox1 As System.WinForms.TextBox
    Private WithEvents Button2 As System.WinForms.Button
    Private WithEvents Button1 As System.WinForms.Button
    
    Dim WithEvents Form1 As System.WinForms.Form
    
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.Button1 = New System.WinForms.Button()
        Me.Button2 = New System.WinForms.Button()
        Me.TextBox1 = New System.WinForms.TextBox()
        
        '@design Me.TrayHeight = 0
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        Button1.Location = New System.Drawing.Point(8, 16)
        Button1.Size = New System.Drawing.Size(75, 23)
        Button1.TabIndex = 0
        Button1.Text = "Subclass"
        
        Button2.Location = New System.Drawing.Point(8, 48)
        Button2.Size = New System.Drawing.Size(75, 23)
        Button2.TabIndex = 1
        Button2.Text = "UnSubclass"
        
        TextBox1.Location = New System.Drawing.Point(88, 16)
        TextBox1.Multiline = True
        TextBox1.ScrollBars = System.WinForms.ScrollBars.Both
        TextBox1.WordWrap = False
        TextBox1.TabIndex = 2
        TextBox1.Size = New System.Drawing.Size(408, 336)
        
        Me.Text = "VB.NET Control Subclassing Example"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(504, 357)
        
        Me.Controls.Add(TextBox1)
        Me.Controls.Add(Button2)
        Me.Controls.Add(Button1)
    End Sub
#End Region
    
    
    
    'SUBCLASS TECHNIQUE #2
    Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        'Don't try to assign handle more than once
        '   - throws a System.Exception error
        
        'NOTE: sc.Handle is the actual handle of the window (see Spy++)
        '      Also notice in Spy++ that the WndProc of the form-not the class-is modified
        '      both when the handle is assigned and unassigned
        
        'sc.Handle = 0
        'sc.FromHandle(sc.Handle) = null
        
        If sc.Handle() = 0 Then
            sc.AssignHandle(TextBox1.Handle)
        Else
            msgbox("Don't try to subclass this control more than once")
        End If
        
        msgbox(Hex(sc.Handle)) ' = 787400
        'Dim x As NativeWindow = sc.FromHandle(sc.Handle)
        'x.Handle = 787400
        'x.ToString() = "VBSubclassing.Form1$MySubclass"
    End Sub
    
    Protected Sub Button2_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        sc.ReleaseHandle()
        'The sc.Handle reverts back to 0
        
        'NOTE:
        'THIS DESTROYS THE WINDOW  --  sc.DestroyHandle()
        'ANY WINDOW WITHOUT A HANDLE IS SUBJECT TO GC
    End Sub
    
    
    Public Class MySubclass
        Inherits NativeWindow
        
        Dim m_MainWindow As Form1
        
        Public Sub SetRefToTextBox(ByVal MainWindow As Form1)
            m_MainWindow = MainWindow
        End Sub
        
        Protected Overrides Sub WndProc(ByRef m As Message)
            If m.msg = microsoft.Win32.Interop.win.WM_RBUTTONDOWN Then
                m_MainWindow.textbox1.Text = m_MainWindow.textbox1.Text & "The right mouse button was pressed. MessageID = " + m.msg.ToString() & chr(13) & chr(10)
            End If
            
            MyBase.WndProc(m)
        End Sub
        
        Protected Overrides Sub OnHandleChange()
            msgbox("Control Handle has changed")
        End Sub
    End Class
End Class
